package com.oledcommlifi.campusipvideodemo;

import oledcomm.android.lifi.GeoAudioAnalysis;
import oledcomm.android.lifi.JackStatus;
import oledcomm.android.lifi.LiFiLocation;
import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.ImageView;
import android.widget.MediaController;
import android.widget.VideoView;

/*
 * Copyright (c) 2014,OLEDCOMM
 * All rights reserved.
 *
 * File nameCampusIPActivity.java
 * Abstract: Video application for CampusIP with two LiFi lamps
 *
 * Version1.0
 * Author: DENG Nan
 * Date: 05 Feb 2014
 *
 */

public class CampusIPActivity extends Activity {

	String video1 = Environment.getExternalStorageDirectory().getPath()
			+ "/campusIP/1.mp4";
	String video2 = Environment.getExternalStorageDirectory().getPath()
			+ "/campusIP/2.mp4";

	boolean tag1_flag = false;
	boolean tag2_flag = false;

	GeoAudioAnalysis location;

	ImageView campusIP_front;

	VideoView campusIP_video;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		campusIP_front = (ImageView) findViewById(R.id.campusIP_front);

		campusIP_video = (VideoView) findViewById(R.id.campusIP_video);

		campusIP_video.setVisibility(View.INVISIBLE);
		campusIP_front.setVisibility(View.VISIBLE);
		campusIP_front.setImageResource(R.drawable.front);

		campusIP_video.setMediaController(new MediaController(
				CampusIPActivity.this));

		// create a new GeoAudioAnalysis object, which is the LiFi receiver
		location = new GeoAudioAnalysis(jack_status, getApplicationContext());
		// start to watch the position changes
		location.watchPosition(position);

	}

	// When you press home button, the app will stop and release the resource.
	@Override
	protected void onStop() {
		super.onStop();
		location.clearPosition();
		finish();
		

	}

	// When the activity is destroyed, the position must be cleared.
	@Override
	protected void onDestroy() {
		super.onDestroy();
		location.clearPosition();
		

	}

	// Screen rotates, nothing should happen
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
		if (newConfig.orientation == Configuration.ORIENTATION_LANDSCAPE) {
			// Nothing need to be done here

		} else {
			// Nothing need to be done here

		}
	}

	LiFiLocation position = new LiFiLocation() {

		@Override
		public void onLocationSuccess(String value) {
			// TODO Auto-generated method stub

			// the tag IDs are received, perform your UI operations based on this
			if ((value.equals("0xfaaa"))) {
				if (tag1_flag == false) {
					tag1_flag = true;

					campusIP_front.setVisibility(View.INVISIBLE);
					campusIP_video.setVisibility(View.VISIBLE);

					campusIP_video.setVideoPath(video1);
					campusIP_video.start();
					campusIP_video.requestFocus();
				}
				tag2_flag = false;

			} else if ((value.split(" ")[0].equals("0x77c4"))) {
				if (tag2_flag == false) {
					tag2_flag = true;

					campusIP_front.setVisibility(View.INVISIBLE);
					campusIP_video.setVisibility(View.VISIBLE);

					campusIP_video.setVideoPath(video2);
					campusIP_video.start();
					campusIP_video.requestFocus();

				}
				tag1_flag = false;

			}

		}

		@Override
		public void onLocationError(int error) {
			// TODO Auto-generated method stub

			// instead of getting a valid ID, the errors are received, also useful for your UI operations
			if (error == LiFiLocation.ERROR_NO_TAG) {
				// write your reaction

			} else if (error == LiFiLocation.ERROR_WRONG_FORMAT) {
				// write your reaction
			}
		}

	};

	JackStatus jack_status = new JackStatus() {

		@Override
		public void onJackEvent(int Event) {
			// TODO Auto-generated method stub

			// you can write your reactions when different JACK sensor status is
			// present

			switch (Event) {
			case JACK_PLUGGED:
				// Toast.makeText(getApplicationContext(),
				// "LiFi sensor plugged",
				// Toast.LENGTH_SHORT).show();
				break;
			case JACK_UNPLUGGED:
				// Toast.makeText(getApplicationContext(),
				// "LiFi sensor unplugged", Toast.LENGTH_SHORT).show();
				break;
			case JACK_ABSENCE:
				// Toast.makeText(getApplicationContext(),
				// "LiFi sensor absence",
				// Toast.LENGTH_SHORT).show();
				break;
			}

		}

	};

}
